 ; Ŀ
 ;   Blora: vertically respace blocks by user specified distance.          
 ;   Also contains Blor: rearrange blocks to fit vertically downwards.     
 ;   Copyright 1996, 2005, 2009 by Rocket Software Ltd.                    
 ;   For those who would rather be hang gliding down Mount Everest.        
 ; 

 ; Ŀ
 ;   Blor - rearrange blocks.                                              
 ; 
 (DEFUN C:BLOR (/ osmo *error* ss pay pap ordlst num enam mxlst top base)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (SHK)
   (setvar "osmode" osmo)
   (command "undo" "end")
  (princ))
 ; Ŀ
 ;   Load some external subroutines ... possibly a dangerous precedent.    
 ; 
  (if (not pussy) (load "puss"))
  (if (not vtol) (load "bean"))
 ; Ŀ
 ;   Get an ss of blocks.                                                  
 ; 
  (prompt "Pick blocks: ")
  (setq ss (ssget (list (cons 0 "INSERT"))))
 ; Ŀ
 ;   Get the entities in order by position.                                
 ; 
  (setq ordlst (vtol ss "y" nil))
 ; Ŀ
 ;   Request a start point.                                                
 ; 
  (setq mxlst (puss (car ordlst)))   ; puss = single block, pussy = an ss
  (setq pay (list (/ (+ (car mxlst) (cadr mxlst)) 2) (caddr mxlst)))
  (setq pap (getpoint pay "\nStart Level:"))
  (if pap (setq pay pap))
  (setq pay (cadr pay))             ; just the y
 ; Ŀ
 ;   The main loop: reshuffle entities.                                    
 ; 
  (setq num 0)
  (while (setq enam (nth num ordlst))
         (setq num (1+ num))
 ; Ŀ
 ;   Find the size of the entity (typically a block).                      
 ; 
         (setq mxlst (puss enam))   ; returns a list: xmax xmin ymax ymin
         (setq top (caddr mxlst))   ; highest y coord.
         (setq base (cadddr mxlst)) ; lowest y coord.
 ; Ŀ
 ;   Move it to the appropriate level, reset the level variable.           
 ; 
         (command "move" enam "" (list 0 top) (list 0 pay))
         (setq pay (- pay (- top base))))
 ; Ŀ
 ;   Clean up and go home.                                                 
 ; 
  (setvar "osmode" osmo)
  (command "undo" "end")
 (princ))


 ; Ŀ
 ;   Blora - rearrange blocks.                                             
 ; 
 (DEFUN C:BLORA (/ *error* osmo ss num txb xa incrp txa enn nna ya yb txh
                                                                   yy nn)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (setvar "osmode" osmo)
   (command "undo" "end")
  (princ))
 ; Ŀ
 ;   Get an ss of blocks and a start point and line spacing.               
 ; 
  (prompt "Pick blocks: ")
  (setq ss (ssget (list (cons 0 "INSERT"))))
  (setq xa (getpoint "\nPick startpoint:"))
  (if (/= (type incr) 'real) (setq incr 6))
  (setq incrp (getdist xa (strcat "\nLine spacing <" (rtos incr 2 2) ">:")))
  (if incrp (setq incr incrp))
 ; Ŀ
 ;   The main loop.                                                        
 ; 
  (setq num 0)
  (while (setq txa (ssname ss 0))             ; first entity name
         (setq enn 1)                         ; entity to test - initialize
         (setq nna (entget txa))              ; the whole thing
         (setq ya (cdr (assoc 10 nna)))       ; Y insertion
 ; Ŀ
 ;   Find the highest entity.                                              
 ; 
         (while (setq txb (ssname ss enn))                 ; next entity
                (setq yb (cdr (assoc 10 (entget txb))))    ; Y insertion
                (if (> (cadr yb) (cadr ya))                ; if txb highest
                    (progn
                         (setq txa txb)                    ; next becomes txa
                         (setq nna (entget txa))           ; get whole thing
                         (setq ya (cdr (assoc 10 nna)))))  ; and Y insertion
                (setq enn (1+ enn)))                       ; next entity
 ; Ŀ
 ;   Move it.                                                              
 ; 
         (setq num (1+ num))
         (setq yy (cdr (assoc 10 nna)))
         (setq nn (list (car yy) (cadr xa)))
         (command "move" txa "" yy nn)
         (setq xa (list (car xa) (- (cadr xa) incr)))
         (ssdel txa ss))
 ; Ŀ
 ;   Debrief, end.                                                         
 ; 
  (if (> num 0)
      (prompt (strcat "\n" (itoa num) " block"
                      (if (= num 1) "" "s") " stratified")))
  (error ())
 (princ))

(princ)